uniform vec3		sundir;
uniform vec3		camdir;

uniform vec3		moondir;
uniform vec3		moonColor;
uniform float		moonCoronasMul;

varying float		h;
varying vec3		vPOS;
varying vec3		cnormal;
//varying float		depth;	
uniform float 		inScatter;
uniform float 		sunpower;
uniform vec3		fogColor;
uniform vec3		zenithColor;
uniform vec3		horizonColor;
uniform float 		extintion;

// costanti passate allo shader
uniform vec3  SUN; 	// = colore del sole
uniform vec3  cBr; 	// = RayLeigh
uniform vec3  cBm; 	// = Mie	
uniform	vec3  C0; 	// = cBr+cBm;	
uniform vec3  C1; 	// = 1.0/(cBr+cBm)*SUN;

uniform float C4;	// = (1-g)^2
uniform float C5;	// = 1+g^2
uniform float C6;	// = 2*g
uniform float C7;	// = 3/2
uniform float fogMultiplier;

/*varying vec4		curpos,
					prev;*/
uniform float		vScale;

uniform sampler2D	starsTex;
uniform sampler2D	cloudsTex;
uniform sampler2D	cirrusTex;
uniform sampler2D	moonTex;
varying vec2		texcoords;
varying vec2		moonTexcoords;
varying vec2		cloudsTexcoords,
					cloudsTexcoords2,
					cloudsTexcoords3,
					cloudsTexcoords4,
					cloudsTexcoords5;
uniform float		cDensity;
varying mat3		TBN;
uniform vec2 		cloudsMat;
uniform vec3 		cloudsColor;

//varying vec2		depth;
//varying vec3 		eyedir;

////////////////////////////
void main()
{
	vec3 sunpos=sundir*vec3(-100.0);
	vec3 tnormal=normalize(cnormal);
	float cos=dot(-sundir,tnormal);
	float cos2=(1.0-step(-cos,0.9999))*16.0;
	
	float F1=(1.0 + cos*cos);
	float F2=(C4/pow(C5-C6*cos,C7));
	
	vec3 Br = cBr*F1;
	vec3 Bm = cBm*F2;
	
	float rf = h;
	float mf = h*0.1;
	vec3 	rd=cBr,
			md=cBm;
	if(abs(rf) > 0.01) rd *=  (1.0 - exp(-rf)) / rf;
	if(abs(mf) > 0.01) md *=  (1.0 - exp(-mf)) / mf;
	vec3 cC0=(rd*rf + md*mf);
	vec3 Fex=exp(-cC0*5000000.0);
	vec3 LinMul=C1*(1.0-Fex);
	vec3 Lin = (Br+Bm)*LinMul*inScatter; 
	vec3 baseColor=mix(zenithColor,horizonColor,h);
	vec3 scatterColor=baseColor + Lin;
	
	// MOON & STARS ///////////////////////////////////////////////
	float stars=texture2D(starsTex,texcoords.st).x;
	vec3 finalColor=scatterColor + cos2*Lin;
	float moonCos=pow(dot(moondir,tnormal),50.0);
	vec4 moonTexColor=vec4(texture2D(moonTex,moonTexcoords.st).x) + max(vec4(moonColor,1.0)*moonCos*moonCoronasMul,0.0);
	vec3 skycolor=max(moonTexColor.xyz*moonColor + finalColor + stars*moonColor*0.2,0.0);
	
// CLOUDS ////////////////////////////////////////////
	vec4 cloudsTexColor=texture2D(cloudsTex,cloudsTexcoords.st);
//	float cloudsTexColor2=texture2D(cirrusTex,cloudsTexcoords2.st).r;
	vec4 cloudsTexColor3=texture2D(cloudsTex,cloudsTexcoords3.st);
	float cloudAlpha=texture2D(cloudsTex,cloudsTexcoords4.st).w;
//	float cloudAlpha2=texture2D(cloudsTex,cloudsTexcoords2.st).w;
	float cloudAlpha3=texture2D(cloudsTex,cloudsTexcoords5.st).w;
	
	float OneMinusDensity=1.0-cDensity;
	float oneOverDens=pow(clamp(1.0/OneMinusDensity,0.0,5.0),5.0);
	float cloudsDensity=clamp( (/*cloudsTexColor.w*/cloudAlpha-OneMinusDensity)*oneOverDens, 0.0,1.0);
//	float cloudsDensity2=clamp( (cloudsTexColor2-OneMinusDensity)*oneOverDens, 0.0,1.0);
	float cloudsDensity3=clamp( (/*cloudsTexColor3.w*/cloudAlpha3-OneMinusDensity)*oneOverDens, 0.0,1.0);
	
	vec3 SunColor=SUN;
	vec3 backLight=max(0.0,pow(-cos,5.0))*SunColor*4.0*cloudsMat.y;
	vec3 L=normalize(sunpos-vPOS);
	SunColor*=cloudsMat.x;
	
	vec3 cNormal=cloudsTexColor.xyz*2.0-1.0;
	vec3 cN=normalize(TBN*cNormal);
	float cCos=dot(L,cN);
	cCos=cCos*0.5+0.5;
	cCos*=cCos;
	vec3 cColor=cloudsColor+vec3(cloudsTexColor.w*cCos)*SunColor+vec3(pow((1.0-cCos),8.0)*1.5)*SunColor+vec3(pow((1.0-cloudsTexColor.w),3.0))*backLight;
	
	/*cNormal=cloudsTexColor2.xyz*2.0-1.0;
	cN=normalize(TBN*cNormal);
	cCos=dot(L,cN);
	cCos=cCos*0.5+0.5;
	cCos*=cCos;*/
	//vec3 cColor2=cloudsColor+SunColor*cloudsTexColor2/*cCos*//*+pow((1.0-cCos),8.0)*1.5*SUN*/+pow((1.0-cloudsTexColor2),3.0)*backLight;
	
	cNormal=cloudsTexColor3.xyz*2.0-1.0;
	cN=normalize(TBN*cNormal);
	cCos=dot(L,cN);
	cCos=cCos*0.5+0.5;
	cCos*=cCos;
	vec3 cColor3=cloudsColor+cloudsTexColor3.w*cCos*SunColor+pow((1.0-cCos),8.0)*SunColor+pow((1.0-cloudsTexColor3.w),3.0)*backLight;
		
//	skycolor=mix(skycolor,cColor2,cloudsDensity2); 
	skycolor=mix(skycolor,cColor,cloudsDensity); 
	skycolor=mix(skycolor,cColor3,cloudsDensity3); 
	
	cloudsDensity=min(cloudsDensity+cloudsDensity+cloudsDensity3,1.0);
	////////////////////////////////////////////
	//gl_FragDepth = clamp((depth.x/depth.y)*0.5 + 0.5,0.0,1.0);
	gl_FragColor.xyz=skycolor;
	gl_FragColor.a=clamp(1.0-cloudsDensity,0.0,1.0);
}
